<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_partner'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('partners/edit/' . $partner->id, $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('partner_id', 'partner_id'); ?>
                        <?php echo form_input('partner_id', $partner->partner_id, 'class="form-control tip" id="partner_id" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('new_partner_id', 'new_partner_id'); ?>
                        <?php echo form_input('new_partner_id', $partner->new_partner_id, 'class="form-control tip" id="new_partner_id" required="required"'); ?>
                    </div>
                    <div class="form-group person">
                        <?= lang('title', 'title'); ?>
                        <?php echo form_input('title', $partner->title, 'class="form-control tip" id="title" required="required"'); ?>
                    </div>
                    <div class="form-group person">
                        <?= lang('name', 'name'); ?>
                        <?php echo form_input('name', $partner->name, 'class="form-control tip" id="name" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('clinic_name', 'clinic_name'); ?>
                        <?php echo form_input('clinic_name', $partner->clinic_name, 'class="form-control" id="clinic_name"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('emrites_id', 'emrites_id'); ?>
                        <?php echo form_input('emrites_id', $partner->emrites_id, 'class="form-control" id="emrites_id"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('partner_share', 'partner_share'); ?>
                        <?php echo form_input('partner_share', $partner->partner_share, 'class="form-control" id="partner_share"'); ?>
                    </div>
                    
                    
                </div>
                <div class="col-md-6">
                    
                    
                    <div class="form-group">
                        <?= lang('email_address', 'email_address'); ?>
                        <input type="email" name="email" class="form-control" required="required" id="email_address"
                               value="<?= $partner->email ?>"/>
                    </div>
                    <div class="form-group">
                        <?= lang('phone', 'phone'); ?>
                        <input type="tel" name="phone" class="form-control" required="required" id="phone"
                               value="<?= $partner->phone ?>"/>
                    </div>
                    <div class="form-group">
                        <?= lang('mobile', 'mobile'); ?>
                        <input type="tel" name="mobile" class="form-control" required="required" id="mobile"
                               value="<?= $partner->mobile ?>"/>
                    </div>
                    <div class="form-group">
                        <?= lang('fax', 'fax'); ?>
                        <?php echo form_input('fax', $partner->fax, 'class="form-control" id="fax" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('address', 'address'); ?>
                        <?php echo form_input('address', $partner->address, 'class="form-control" id="address" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('city', 'city'); ?>
                        <?php echo form_input('city', $partner->city, 'class="form-control" id="city" required="required"'); ?>
                    </div>

                </div>
                

        </div>
        <div class="modal-footer">
            <?php echo form_submit('edit_partner', lang('edit_partner'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
    });
</script>
<?= $modal_js ?>

