<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_mortality_rec'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('mortality_recs/edit/' . $mortality_rec->id, $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('animal_tag', 'animal_tag'); ?>
                        <?php echo form_input('animal_tag', $mortality_rec->animal_tag, 'class="form-control" id="animal_tag" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('animal_id', 'animal_id'); ?>
                        <?php echo form_input('animal_id', $mortality_rec->animal_id, 'class="form-control" id="animal_id" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('mother_id', 'mother_id'); ?>
                        <?php echo form_input('mother_id', $mortality_rec->mother_id, 'class="form-control" id="mother_id" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    
                    <div class="form-group">
                        <?= lang('date_of_death', 'date_of_death'); ?>
                        <input name="date_of_death" value="<?= $mortality_rec->date_of_death ?>" class="form-control datetime" required="required" id="date_of_death"/>
                    </div>
                    <div class="form-group">
                        <?= lang('age_of_death', 'age_of_death'); ?>
                        <?php echo form_input('age_of_death', $mortality_rec->age_of_death, 'class="form-control" id="age_of_death" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('death_reason', 'death_reason'); ?>
                        <?php echo form_input('death_reason', $mortality_rec->death_reason, 'class="form-control" id="death_reason" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('eew_ram', 'eew_ram'); ?>
                        <?php echo form_dropdown('eew_ram', array('eew' => lang('eew'), 'ram' => lang('ram')), $mortality_rec->eew_ram, 'class="form-control tip" id="eew_ram" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('adult_new', 'adult_new'); ?>
                        <?php echo form_dropdown('adult_new', array('adult' => lang('adult'), 'new' => lang('new')), $mortality_rec->adult_new, 'class="form-control tip" id="adult_new" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('doctor', 'doctor'); ?>
                        <?php echo form_input('doctor', $mortality_rec->doctor, 'class="form-control" id="doctor" data-bv-notempty="true"'); ?>
                    </div>

                </div>
                
                <div class="form-group col-md-6 all">
                        <?= lang('image', 'image') ?>
                        <input id="image" type="file" data-browse-label="<?= lang('browse'); ?>" name="image" data-show-upload="false"
                               data-show-preview="false" accept="image/*" class="form-control-file file">
                </div>
                
                <div class="col-md-12">
                    <div class="form-group">
                        <?= lang('description', 'description'); ?>
                        <?php echo form_textarea('description', $mortality_rec->description, 'class="form-control skip" id="description" style="height:100px;"'); ?>
                    </div>
                </div>
                
            </div>
        <div class="modal-footer">
            <?php echo form_submit('edit_mortality_rec', lang('edit_mortality_rec'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="<?= base_url() ?>assets/js/auto_search.js"></script>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
    });
    auto_search('animal_tag', 'animals', 'animal_tag', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('mother_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('doctor', 'doctors', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('death_reason', 'deathreasons', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
</script>
<style type="text/css">
ul.ui-autocomplete {
    z-index: 1100;
}
</style>
<?= $modal_js ?>

