<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Partners_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addPartners($data = [])
    {
        if ($this->db->insert_batch('partners', $data)) {
            return true;
        }
        return false;
    }

    public function addPartner($data = [])
    {
        if ($this->db->insert('partners', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deletePartner($id)
    {
        if ($this->db->delete('partners', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getPartnerByEmail($email)
    {
        $q = $this->db->get_where('partners', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getPartnerByID($id)
    {
        $q = $this->db->get_where('partners', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updatePartner($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('partners', $data)) {
            return true;
        }
        return false;
    }

}
