<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Medicine_recs_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addMedicine_recs($data = [])
    {
        if ($this->db->insert_batch('medicine_recs', $data)) {
            return true;
        }
        return false;
    }

    public function addMedicine_rec($data = [])
    {
        if ($this->db->insert('medicine_recs', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteMedicine_rec($id)
    {
        if ($this->db->delete('medicine_recs', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getMedicine_recByEmail($email)
    {
        $q = $this->db->get_where('medicine_recs', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getMedicine_recByID($id)
    {
        $q = $this->db->get_where('medicine_recs', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateMedicine_rec($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('medicine_recs', $data)) {
            return true;
        }
        return false;
    }

}
