<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Doctors_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addDoctors($data = [])
    {
        if ($this->db->insert_batch('doctors', $data)) {
            return true;
        }
        return false;
    }

    public function addDoctor($data = [])
    {
        if ($this->db->insert('doctors', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteDoctor($id)
    {
        if ($this->db->delete('doctors', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getDoctorByEmail($email)
    {
        $q = $this->db->get_where('doctors', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getDoctorByID($id)
    {
        $q = $this->db->get_where('doctors', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateDoctor($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('doctors', $data)) {
            return true;
        }
        return false;
    }

}
