<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Animals_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addAnimals($data = [])
    {
        if ($this->db->insert_batch('animals', $data)) {
            return true;
        }
        return false;
    }

    public function addAnimal($data = [])
    {
        if ($this->db->insert('animals', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteAnimal($id)
    {
        if ($this->db->delete('animals', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getAnimalByEmail($email)
    {
        $q = $this->db->get_where('animals', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getAnimalByID($id)
    {
        $q = $this->db->get_where('animals', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateAnimal($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('animals', $data)) {
            return true;
        }
        return false;
    }

}
