<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Partners extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->lang->admin_load('partners', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('partners_model');
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        $this->form_validation->set_rules('email', $this->lang->line('email_address'), 'is_unique[partners.email]');

        if ($this->form_validation->run('partners/add') == true) {
            $data = [
                'partner_id' => $this->input->post('partner_id'),
                'new_partner_id'=> $this->input->post('new_partner_id'),
                'title' => $this->input->post('title'),
                'name' => $this->input->post('name'),
                'contact'=> $this->input->post('contact'),
                'emrites_id' => $this->input->post('emrites_id'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'mobile' => $this->input->post('mobile'),
                'fax' => $this->input->post('fax'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'partner_share'=> $this->input->post('partner_share'),
            ];
        } elseif ($this->input->post('add_partner')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('partners');
        }

        if ($this->form_validation->run() == true && $this->partners_model->addPartner($data)) {
            $this->session->set_flashdata('message', $this->lang->line('partner_added'));
            admin_redirect('partners');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'partners/add', $this->data);
        }
    }

    public function partner_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->partners_model->deletePartner($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('partners_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('partners_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('partners'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('company'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('phone'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('email'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('city'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $customer = $this->site->getPartnerByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $customer->company);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $customer->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $customer->phone);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $customer->email);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $customer->city);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'partners_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_partner_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->partners_model->deletePartner($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('partner_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('partner_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $partner_details = $this->partners_model->getPartnerByID($id);
        if ($this->input->post('email') != $partner_details->email) {
            $this->form_validation->set_rules('code', lang('email_address'), 'is_unique[partners.email]');
        }
        
        function debug_to_console($data) {
            $output = $data;
            if (is_array($output))
                $output = implode(',', $output);
        
            echo "<script>console.log('Debug Objects: " . $output . "' );</script>";
        }

        if ($this->form_validation->run('partners/add') == true) {
            
            $data = [
                'partner_id' => $this->input->post('partner_id'),
                'new_partner_id'=> $this->input->post('new_partner_id'),
                'title' => $this->input->post('title'),
                'name' => $this->input->post('name'),
                'contact'=> $this->input->post('contact'),
                'emrites_id' => $this->input->post('emrites_id'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'mobile' => $this->input->post('mobile'),
                'fax' => $this->input->post('fax'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'partner_share'=> $this->input->post('partner_share'),
            ];
        } elseif ($this->input->post('edit_partner')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('partners');
        }

        if ($this->form_validation->run() == true && $this->partners_model->updatePartner($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('partner_updated'));
            admin_redirect('partners');
        } else {
            $this->data['partner']   = $partner_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'partners/edit', $this->data);
        }
    }

    public function getPartner($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->partners_model->getPartnerByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getPartners()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, title, name, contact, phone, email, city, address')
            ->from('partners')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_partner') . "' href='" . admin_url('partners/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_partner') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('partners/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('partners')]];
        $meta                 = ['page_title' => lang('partners'), 'bc' => $bc];
        $this->page_construct('partners/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->partners_model->getPartnerSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
}
