<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Doctors extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->lang->admin_load('doctors', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('doctors_model');
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        $this->form_validation->set_rules('email', $this->lang->line('email_address'), 'is_unique[doctors.email]');

        if ($this->form_validation->run('doctors/add') == true) {
            $data = [
                'doctor_id' => $this->input->post('doctor_id'),
                'new_doctor_id'=> $this->input->post('new_doctor_id'),
                'title' => $this->input->post('title'),
                'name' => $this->input->post('name'),
                'clinic_name'=> $this->input->post('clinic_name'),
                'emrites_id' => $this->input->post('emrites_id'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'mobile' => $this->input->post('mobile'),
                'fax' => $this->input->post('fax'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
            ];
        } elseif ($this->input->post('add_doctor')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('doctors');
        }

        if ($this->form_validation->run() == true && $this->doctors_model->addDoctor($data)) {
            $this->session->set_flashdata('message', $this->lang->line('doctor_added'));
            admin_redirect('doctors');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'doctors/add', $this->data);
        }
    }

    public function doctor_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->doctors_model->deleteDoctor($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('doctors_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('doctors_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('doctors'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('company'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('phone'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('email'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('city'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $customer = $this->site->getDoctorByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $customer->company);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $customer->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $customer->phone);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $customer->email);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $customer->city);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'doctors_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_doctor_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->doctors_model->deleteDoctor($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('doctor_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('doctor_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $doctor_details = $this->doctors_model->getDoctorByID($id);
        if ($this->input->post('email') != $doctor_details->email) {
            $this->form_validation->set_rules('code', lang('email_address'), 'is_unique[doctors.email]');
        }
        
        function debug_to_console($data) {
            $output = $data;
            if (is_array($output))
                $output = implode(',', $output);
        
            echo "<script>console.log('Debug Objects: " . $output . "' );</script>";
        }

        if ($this->form_validation->run('doctors/add') == true) {
            
            $data = [
                'doctor_id' => $this->input->post('doctor_id'),
                'new_doctor_id'=> $this->input->post('new_doctor_id'),
                'title' => $this->input->post('title'),
                'name' => $this->input->post('name'),
                'clinic_name'=> $this->input->post('clinic_name'),
                'emrites_id' => $this->input->post('emrites_id'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'mobile' => $this->input->post('mobile'),
                'fax' => $this->input->post('fax'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
            ];
        } elseif ($this->input->post('edit_doctor')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('doctors');
        }

        if ($this->form_validation->run() == true && $this->doctors_model->updateDoctor($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('doctor_updated'));
            admin_redirect('doctors');
        } else {
            $this->data['doctor']   = $doctor_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'doctors/edit', $this->data);
        }
    }

    public function getDoctor($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->doctors_model->getDoctorByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getDoctors()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, title, name, clinic_name, phone, email, city, address')
            ->from('doctors')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_doctor') . "' href='" . admin_url('doctors/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_doctor') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('doctors/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('doctors')]];
        $meta                 = ['page_title' => lang('doctors'), 'bc' => $bc];
        $this->page_construct('doctors/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->doctors_model->getDoctorSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
}
