<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Born_recs extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->load->library('upload');
        $this->lang->admin_load('born_recs', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('born_recs_model');
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->form_validation->run('born_recs/add') == true) {
            $data = [
                'animal_id' => $this->input->post('animal_id'),
                'animal_tag' => $this->input->post('animal_tag'),
                'father_id' => $this->input->post('father_id'),
                'mother_id' => $this->input->post('mother_id'),
                'breed'=> $this->input->post('breed'),
                'health_status'=> $this->input->post('health_status'),
                'bcs' => $this->input->post('bcs'),
                'dob' => $this->input->post('dob'),
                'weight'=> $this->input->post('weight'),
                'birth_status' => $this->input->post('birth_status'),
                'eew_ram' => $this->input->post('eew_ram'),
                'employee_delivered' => $this->input->post('employee_delivered'),
                'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                // $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('born_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
        } elseif ($this->input->post('add_born_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('born_recs');
        }

        if ($this->form_validation->run() == true && $this->born_recs_model->addBorn_rec($data)) {
            $this->session->set_flashdata('message', $this->lang->line('born_rec_added'));
            admin_redirect('born_recs');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'born_recs/add', $this->data);
        }
    }

    public function born_rec_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->born_recs_model->deleteBorn_rec($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('born_recs_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('born_recs_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('born_recs'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('animal_id'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('health_status'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('bcs'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('dob'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('weight'));
                    $this->excel->getActiveSheet()->SetCellValue('F1', lang('birth_status'));
                    $this->excel->getActiveSheet()->SetCellValue('G1', lang('eew_ram'));
                    $this->excel->getActiveSheet()->SetCellValue('H1', lang('employee_delivered'));
                    $this->excel->getActiveSheet()->SetCellValue('I1', lang('description'));
                    $this->excel->getActiveSheet()->SetCellValue('J1', lang('animal_tag'));
                    $this->excel->getActiveSheet()->SetCellValue('K1', lang('father_id'));
                    $this->excel->getActiveSheet()->SetCellValue('L1', lang('mother_id'));
                    $this->excel->getActiveSheet()->SetCellValue('M1', lang('breed'));
                    
                    

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $obj = $this->born_recs_model->getBorn_recByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $obj->animal_id);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $obj->health_status);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $obj->bcs);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $obj->dob);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $obj->weight);
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, $obj->birth_status);
                        $this->excel->getActiveSheet()->SetCellValue('G' . $row, $obj->eew_ram);
                        $this->excel->getActiveSheet()->SetCellValue('H' . $row, $obj->employee_delivered);
                        $this->excel->getActiveSheet()->SetCellValue('I' . $row, $obj->description);
                        $this->excel->getActiveSheet()->SetCellValue('J' . $row, $obj->animal_tag);
                        $this->excel->getActiveSheet()->SetCellValue('K' . $row, $obj->father_id);
                        $this->excel->getActiveSheet()->SetCellValue('L' . $row, $obj->mother_id);
                        $this->excel->getActiveSheet()->SetCellValue('M' . $row, $obj->breed);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'born_recs_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_born_rec_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->born_recs_model->deleteBorn_rec($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('born_rec_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('born_rec_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $born_rec_details = $this->born_recs_model->getBorn_recByID($id);

        if ($this->form_validation->run('born_recs/add') == true) {
            
            $data = [
                'animal_id' => $this->input->post('animal_id'),
                'animal_tag' => $this->input->post('animal_tag'),
                'father_id' => $this->input->post('father_id'),
                'mother_id' => $this->input->post('mother_id'),
                'breed'=> $this->input->post('breed'),
                'health_status'=> $this->input->post('health_status'),
                'bcs' => $this->input->post('bcs'),
                'dob' => $this->input->post('dob'),
                'weight'=> $this->input->post('weight'),
                'birth_status' => $this->input->post('birth_status'),
                'eew_ram' => $this->input->post('eew_ram'),
                'employee_delivered' => $this->input->post('employee_delivered'),
                'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                // $config['overwrite']     = true;
                // $config['file_name'] = $born_rec_details->image;
                
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('born_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
            
        } elseif ($this->input->post('edit_born_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('born_recs');
        }

        if ($this->form_validation->run() == true && $this->born_recs_model->updateBorn_rec($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('born_rec_updated'));
            admin_redirect('born_recs');
        } else {
            $this->data['born_rec']   = $born_rec_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'born_recs/edit', $this->data);
        }
    }

    public function getBorn_rec($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->born_recs_model->getBorn_recByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getBorn_recs()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, image, animal_id, animal_tag, health_status, bcs, dob, weight, birth_status, eew_ram, employee_delivered')
            ->from('born_recs')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_born_rec') . "' href='" . admin_url('born_recs/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_born_rec') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('born_recs/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('born_recs')]];
        $meta                 = ['page_title' => lang('born_recs'), 'bc' => $bc];
        $this->page_construct('born_recs/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->born_recs_model->getBorn_recSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
    
    public function modal_view($id = null)
    {
        $this->sma->checkPermissions('index', true);

        $pr_details = $this->born_recs_model->getBorn_recByID($id);
        
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('born_rec_not_found'));
            $this->sma->md();
        }
        
        $this->data['born_rec']     = $pr_details;

        $this->load->view($this->theme . 'born_recs/modal_view', $this->data);
    }
    
    public function pdf($id = null, $view = null)
    {
        $this->sma->checkPermissions('index');

        $pr_details = $this->born_recs_model->getBorn_recByID($id);
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('prduct_not_found'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        
        $this->data['born_rec'] = $pr_details;

        $name = lang('born_rec') . '_' . $pr_details->id  . '.pdf';
        if ($view) {
            $this->load->view($this->theme . 'born_recs/pdf', $this->data);
        } else {
            $html = $this->load->view($this->theme . 'born_recs/pdf', $this->data, true);
            if (!$this->Settings->barcode_img) {
                $html = preg_replace("'\<\?xml(.*)\?\>'", '', $html);
            }
            $this->sma->generate_pdf($html, $name);
        }
    }

}
