<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
    .sickness_recs_list_row { cursor: pointer; }
</style>
<script>
    $(document).ready(function () {
        oTable = $('#SupData').dataTable({
            "aaSorting": [[1, "asc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
            "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= admin_url('sickness_recs/getSickness_recs') ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            'fnRowCallback': function (nRow, aData, iDisplayIndex) {
                var oSettings = oTable.fnSettings();
                nRow.id = aData[0];
                nRow.className = "sickness_recs_list_row";
                return nRow;
            },
            "aoColumns": [{
                "bSortable": false,
                "mRender": checkbox,
            }, {
                "bSortable": false,
                "mRender": function (data, type, full) {
                   return '<img style="width: 40px;" src="' + 'assets/uploads/' + full[1] + '"></>';
                },
            }, null, null, null, null, null, null, null, null, null, null, null, null, {"bSortable": false}]
        }).dtFilter([
            {column_number: 2, filter_default_label: "[<?=lang('animal_id');?>]", filter_type: "text", data: []},
            {column_number: 3, filter_default_label: "[<?=lang('animal_tag');?>]", filter_type: "text", data: []},
            {column_number: 4, filter_default_label: "[<?=lang('mother_id');?>]", filter_type: "text", data: []},
            {column_number: 5, filter_default_label: "[<?=lang('symptoms');?>]", filter_type: "text", data: []},
            {column_number: 6, filter_default_label: "[<?=lang('diagnosis_date');?>]", filter_type: "text", data: []},
            {column_number: 7, filter_default_label: "[<?=lang('weight');?>]", filter_type: "text", data: []},
            {column_number: 8, filter_default_label: "[<?=lang('disease');?>]", filter_type: "text", data: []},
            {column_number: 9, filter_default_label: "[<?=lang('sickness_withdrawl_period');?>]", filter_type: "text", data: []},
            {column_number: 10, filter_default_label: "[<?=lang('eew_ram');?>]", filter_type: "text", data: []},
            {column_number: 11, filter_default_label: "[<?=lang('adult_new');?>]", filter_type: "text", data: []},
            {column_number: 12, filter_default_label: "[<?=lang('doctor');?>]", filter_type: "text", data: []},
            {column_number: 13, filter_default_label: "[<?=lang('medication');?>]", filter_type: "text", data: []},
        ], "footer");
        
        $('body').on('click', '.sickness_recs_list_row td:not(:first-child, :last-child)', function() {
            $('#myModal').modal({
            remote:
                site.base_url +
                'sickness_recs/modal_view/' +
                $(this)
                    .parent('.sickness_recs_list_row')
                    .attr('id'),
        });
        $('#myModal').modal('show');
        });
    });
</script>
<?php if ($Owner || ($GP && $GP['bulk_actions'])) {
    echo admin_form_open('sickness_recs/sickness_rec_actions', 'id="action-form"');
} ?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-users"></i><?= lang('sickness_recs'); ?></h2>

        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#"><i class="icon fa fa-tasks tip" data-placement="left" title="<?= lang('actions') ?>"></i></a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu" aria-labelledby="dLabel">
                        <li><a href="<?= admin_url('sickness_recs/add'); ?>" data-toggle="modal" data-target="#myModal" id="add"><i class="fa fa-plus-circle"></i> <?= lang('add_sickness_rec'); ?></a></li>
                        <li><a href="<?= admin_url('add_by_csvs/add/sickness_recs'); ?>"><i class="fa fa-plus-circle"></i> <?= lang('add_data_by_csv') ?></a></li>
                        <li><a href="#" id="excel" data-action="export_excel"><i class="fa fa-file-excel-o"></i> <?= lang('export_to_excel') ?></a></li>
                        <li class="divider"></li>
                        <li><a href="#" class="bpo" title="<b><?= $this->lang->line('delete_sickness_recs') ?></b>" data-content="<p><?= lang('r_u_sure') ?></p><button type='button' class='btn btn-danger' id='delete' data-action='delete'><?= lang('i_m_sure') ?></a> <button class='btn bpo-close'><?= lang('no') ?></button>" data-html="true" data-placement="left"><i class="fa fa-trash-o"></i> <?= lang('delete_sickness_recs') ?></a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">

                <p class="introtext"><?= lang('list_results'); ?></p>

                <div class="table-responsive">
                    <table id="SupData" cellpadding="0" cellspacing="0" border="0"
                           class="table table-bordered table-condensed table-hover table-striped">
                        <thead>
                        <tr class="primary">
                            <th style="min-width:30px; width: 30px; text-align: center;">
                                <input class="checkbox checkth" type="checkbox" name="check"/>
                            </th>
                            <th style="min-width:40px; width: 40px; text-align: center;"><?php echo $this->lang->line('image'); ?></th>
                            <th><?= lang('animal_id'); ?></th>
                            <th><?= lang('animal_tag'); ?></th>
                            <th><?= lang('mother_id'); ?></th>
                            <th><?= lang('symptoms'); ?></th>
                            <th><?= lang('diagnosis_date'); ?></th>
                            <th><?= lang('weight'); ?></th>
                            <th><?= lang('disease'); ?></th>
                            <th><?= lang('sickness_withdrawl_period'); ?></th>
                            <th><?= lang('eew_ram'); ?></th>
                            <th><?= lang('adult_new'); ?></th>
                            <th><?= lang('doctor'); ?></th>
                            <th><?= lang('medication'); ?></th>
                            <th style="width:85px;"><?= lang('actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td colspan="9" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
                        </tr>
                        </tbody>
                        <tfoot class="dtFilter">
                        <tr class="active">
                            <th style="min-width:30px; width: 30px; text-align: center;">
                                <input class="checkbox checkft" type="checkbox" name="check"/>
                            </th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th style="width:85px;" class="text-center"><?= lang('actions'); ?></th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php if ($Owner || ($GP && $GP['bulk_actions'])) {
    ?>
    <div style="display: none;">
        <input type="hidden" name="form_action" value="" id="form_action"/>
        <?= form_submit('performAction', 'performAction', 'id="action-form-submit"') ?>
    </div>
    <?= form_close() ?>
    <?php
} ?>
<?php if ($action && $action == 'add') {
        echo '<script>$(document).ready(function(){$("#add").trigger("click");});</script>';
}
?>
    

