<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                <i class="fa fa-2x">&times;</i>
            </button>
            <button type="button" class="btn btn-xs btn-default no-print pull-right" style="margin-right:15px;" onclick="window.print();">
                <i class="fa fa-print"></i> <?= lang('print'); ?>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?= lang('medicine_rec') ?></h4>
        </div>
        
        <div class="modal-body">

            <div class="row">
                <div class="col-xs-5">
                    <img id="pr-image" src="<?= base_url() ?>assets/uploads/<?= $medicine_rec->image ?>"
                    alt="<?= $medicine_rec->id ?>" class="img-responsive img-thumbnail"/>
                </div>
                
                <div class="col-xs-7">
                <?php
                    $medicine_rec_array = json_decode(json_encode($medicine_rec), true);
                    foreach($medicine_rec_array as $key => $value) { ?>
                        <?php if ($key != 'image' && $key != 'id' && $key != 'item_json') { ?>
                    
                            <div class="table-responsive">
                                <table class="table table-borderless table-striped dfTable table-right-left">
                                    <tbody>
                                        <tr>
                                            <td><?= lang($key) ?></td>
                                            <td><?= $value ?></td>
                                        </tr>
        
                                    </tbody>
                                </table>
                            </div>
                
                        <?php  } ?>
                        
                    <?php  } ?>
                       
                </div>
                
                <div class="buttons">
                    <div class="btn-group btn-group-justified">
                        
                        <div class="btn-group">
                            <a href="<?= admin_url('medicine_recs/pdf/' . $medicine_rec->id) ?>" class="tip btn btn-primary" title="<?= lang('pdf') ?>">
                                <i class="fa fa-download"></i>
                                <span class="hidden-sm hidden-xs"><?= lang('pdf') ?></span>
                            </a>
                        </div>
                        <div class="btn-group">
                            <a href="#" class="tip btn btn-danger bpo" title="<b><?= lang('delete_medicine_rec') ?></b>"
                                data-content="<div style='width:150px;'><p><?= lang('r_u_sure') ?></p><a class='btn btn-danger' href='<?= admin_url('medicine_recs/delete/' . $medicine_rec->id) ?>'><?= lang('i_m_sure') ?></a> <button class='btn bpo-close'><?= lang('no') ?></button></div>"
                                data-html="true" data-placement="top">
                                <i class="fa fa-trash-o"></i>
                                <span class="hidden-sm hidden-xs"><?= lang('delete') ?></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

</div>
</div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    $('.change_img').click(function(event) {
        event.preventDefault();
        var img_src = $(this).attr('href');
        $('#pr-image').attr('src', img_src);
        return false;
    });
});
</script>
