<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('add_born_rec'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('born_recs/add', $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <?= lang('animal_tag', 'animal_tag'); ?>
                        <?php echo form_input('animal_tag', '', 'class="form-control" id="animal_tag" data-bv-notempty="true"'); ?>
                    </div>
                    
                    <div class="form-group">
                        <?= lang('dob', 'dob'); ?>
                        <input name="dob" class="form-control datetime" required="required" id="dob"/>
                    </div>
                    
                    <div class="form-group">
                        <?= lang('mother_id', 'mother_id'); ?>
                        <?php echo form_input('mother_id', '', 'class="form-control" id="mother_id" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                
                <div class="col-md-3">
                    
                        <div class="form-group">
                            <?= lang('bcs', 'bcs'); ?>
                            <?php echo form_dropdown('bcs', range(0, 10), '', 'class="form-control tip" id="bcs" data-bv-notempty="true"'); ?>
                        </div>
                        
                        <div class="form-group">
                            <?= lang('weight', 'weight'); ?>
                            <?php echo form_input('weight', '', 'class="form-control" id="weight" data-bv-notempty="true"'); ?>
                        </div>
                        
                        <div class="form-group">
                            <?= lang('father_id', 'father_id'); ?>
                            <?php echo form_input('father_id', '', 'class="form-control" id="father_id" data-bv-notempty="true"'); ?>
                        </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <?= lang('birth_status', 'birth_status'); ?>
                        <?php echo form_input('birth_status', '', 'class="form-control" id="birth_status" data-bv-notempty="true"'); ?>
                    </div>
                    
                    <div class="form-group">
                        <?= lang('health_status', 'health_status'); ?>
                        <?php echo form_input('health_status', '', 'class="form-control" id="health_status" data-bv-notempty="true"'); ?>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <?= lang('employee_delivered', 'employee_delivered'); ?>
                        <?php echo form_input('employee_delivered', '', 'class="form-control" id="employee_delivered" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('breed', 'breed'); ?>
                        <?php echo form_input('breed', '', 'class="form-control tip" id="breed" data-bv-notempty="true"'); ?>
                    </div>
                </div>
                
                <div class="col-md-12">
                    <div class="form-group">
                        <?= lang('birth_type', 'birth_type'); ?>
                        <?php echo form_dropdown('birth_type', array('single' => lang('single'), 'twins' => lang('twins'), 'triplets' => lang('triplets'), 'quadruplets' => lang('quadruplets')), '', 'class="form-control tip" id="birth_type" data-bv-notempty="true"'); ?>
                    </div>
                </div>
                
                <div id="birth_type_res" class="col-md-12">
                    
                </div>
                
                <input type="hidden" id="animal_id" name="animal_id">
                <input type="hidden" id="eew_ram" name="eew_ram">
                
                <div class="form-group col-md-6 all">
                        <?= lang('image', 'image') ?>
                        <input id="image" type="file" data-browse-label="<?= lang('browse'); ?>" name="image" data-show-upload="false"
                               data-show-preview="false" accept="image/*" class="form-control-file file">
                </div>
                
                <div class="col-md-12">
                    <div class="form-group">
                        <?= lang('description', 'description'); ?>
                        <?php echo form_textarea('description', '', 'class="form-control skip" id="description" style="height:100px;"'); ?>
                    </div>
                </div>
                
            </div>


        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_born_rec', lang('add_born_rec'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="<?= base_url() ?>assets/js/auto_search.js"></script>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
        
        var animalIdObj = {};
        var eewRamObj = {};
        
        function setOnChanges(i) {
            
            $(`#eew_ram_${i}`).off('change');
            $(`#animal_id_${i}`).off('change paste keyup')

            $(`#animal_id_${i}`).on("change paste keyup", function() {
               var animalId = $(`#animal_id_${i}`).val();
                animalIdObj[i] = animalId;
                $("#animal_id").val("")
                Object.values(animalIdObj).forEach((aId) => {
                    var a = $("#animal_id").val();
                    $("#animal_id").val(a + "," + aId);
                })
                
                $("#animal_id").val($("#animal_id").val().substring(1))
            });

            $(`#eew_ram_${i}`).on('change',function(){
                var eewRam = $(`#eew_ram_${i}`).find(":selected").text();
                eewRamObj[i] = eewRam;
                $("#eew_ram").val("")
                Object.values(eewRamObj).forEach((aId) => {
                    var a = $("#eew_ram").val();
                    $("#eew_ram").val(a + "," + aId);
                })
                
                $("#eew_ram").val($("#eew_ram").val().substring(1))
            });
            
        }
        
        function setBirthDataViews(bType) {
            var n = 1;
            
            switch(bType) {
                case "<?= lang('single') ?>":
                    n = 1;
                break;
                case "<?= lang('twins') ?>":
                    n = 2;
                break;
                case "<?= lang('triplets') ?>":
                    n = 3;
                break;
                case "<?= lang('quadruplets') ?>":
                    n = 4;
                break;
                default:
                    n = 1;
            }
            
            $("#birth_type_res").empty();
            animalIdObj = {};
            eewRamObj = {};
            
            for (var i = 1; i <= n; i++) {
                $("#birth_type_res").append(`<div class="col-md-12">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('animal_id', 'animal_id'); ?>
                            <?php echo form_input('animal_id_${i}', '', 'class="form-control" id="animal_id_${i}" data-bv-notempty="true"'); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('eew_ram', 'eew_ram'); ?>
                            <?php echo form_dropdown('eew_ram_${i}', array('eew' => lang('eew'), 'ram' => lang('ram')), '', 'class="form-control tip" id="eew_ram_${i}" data-bv-notempty="true"'); ?>
                        </div>
                    </div>
                </div>`);
                
                eewRamObj[i] = "<?= lang('eew'); ?>";
                animalIdObj[i] = 0;
                
                setOnChanges(i);
                
            }
            
        }
        
        
        $(document).on('change','#birth_type',function(){
            var bType = $("select[name='birth_type'] option:selected").text();
            setBirthDataViews(bType);
        });
        
        
    });
    auto_search('animal_tag', 'animals', 'animal_tag', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('employee_delivered', 'doctors', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('health_status', 'born_recs', 'health_status', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('birth_status', 'born_recs', 'birth_status', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('breed', 'breeds', 'breed', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('mother_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('father_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
</script>
<style type="text/css">
ul.ui-autocomplete {
    z-index: 1100;
}
</style>
<?= $modal_js ?>
