<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_ben_rec'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('ben_recs/edit/' . $ben_rec->id, $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('ref_no', 'ref_no'); ?>
                        <?php echo form_input('ref_no', $ben_rec->ref_no, 'class="form-control" id="ref_no" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('ben_no', 'ben_no'); ?>
                        <?php echo form_input('ben_no', $ben_rec->ben_no, 'class="form-control" id="ben_no" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    
                    <div class="form-group">
                        <?= lang('breeding_start_date', 'breeding_start_date'); ?>
                        <input name="breeding_start_date" value="<?= $ben_rec->breeding_start_date ?>" class="form-control datetime" required="required" id="breeding_start_date"/>
                    </div>
                    <div class="form-group">
                        <?= lang('breeding_end_date', 'breeding_end_date'); ?>
                        <input name="breeding_end_date" value="<?= $ben_rec->breeding_end_date ?>" class="form-control datetime" id="breeding_end_date"/>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    
                    <div class="form-group">
                        <?= lang('male_animal_id', 'male_animal_id'); ?>
                        <?php echo form_input('male_animal_id', $ben_rec->male_animal_id, 'class="form-control" id="male_animal_id" data-bv-notempty="true"'); ?>
                    </div>
                    
                    <div class="form-group">
                        <?= lang('female_animal_id', 'female_animal_id'); ?>
                        <?php echo form_input('female_animal_id_input', '', 'class="form-control" id="female_animal_id_input"'); ?>
                        <input type="hidden" id="female_animal_id" name="female_animal_id" value="<?= $ben_rec->female_animal_id ?>"/>
                    </div>
                    <?= lang('selected_female_animal_ids', 'selected_female_animal_ids'); ?>
                    <div id="result_female_animal_id"><?= $ben_rec->female_animal_id ?></div>

                </div>
                
                <div class="form-group col-md-6 all">
                        <?= lang('image', 'image') ?>
                        <input id="image" type="file" data-browse-label="<?= lang('browse'); ?>" name="image" data-show-upload="false"
                               data-show-preview="false" accept="image/*" class="form-control-file file">
                </div>
                
                <div class="col-md-12">
                    <div class="form-group">
                        <?= lang('description', 'description'); ?>
                        <?php echo form_textarea('description', $ben_rec->description, 'class="form-control skip" id="description" style="height:100px;"'); ?>
                    </div>
                </div>
                
            </div>
        <div class="modal-footer">
            <?php echo form_submit('edit_ben_rec', lang('edit_ben_rec'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="<?= base_url() ?>assets/js/auto_search.js"></script>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
    });
    
    auto_search('male_animal_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
    
    function auto_search_ben(domId, table, column, reqUrl) {
    let dom = $('#'+domId);
        dom.autocomplete({
            source: function (request, response) {
                $.ajax({
                    type: 'get',
                    url: reqUrl,
                    dataType: "json",
                    data: { term: request.term, table: table, column: column },
                    success: function (data) {
                        response(data);
                    }
                });
            },
            select: function (event, ui) {
                var l = ui.item.label;
              dom.val('');
              if($('#female_animal_id').val() == '') {
                  $('#female_animal_id').val(l)
              } else {
                $('#female_animal_id').val($('#female_animal_id').val() + ',' + l);
              }
              $('#result_female_animal_id').text($('#female_animal_id').val());
              return false;
            }
        });
    }
    
    auto_search_ben('female_animal_id_input', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');

    
</script>
<style type="text/css">
ul.ui-autocomplete {
    z-index: 1100;
}
</style>
<?= $modal_js ?>

