<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('add_animal'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('animals/add', $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('animal_tag', 'animal_tag'); ?>
                        <?php echo form_input('animal_tag', '', 'class="form-control" id="animal_tag" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('breed', 'breed'); ?>
                        <?php echo form_input('breed', '', 'class="form-control tip" id="breed" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('new_purchased', 'new_purchased'); ?>
                        <?php echo form_dropdown('new_purchased', array('new' => lang('new'), 'purchased' => lang('purchased')), '', 'class="form-control tip" id="new_purchased" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('live_dead', 'live_dead'); ?>
                        <?php echo form_dropdown('live_dead', array('live' => lang('live'), 'dead' => lang('dead')), '', 'class="form-control tip" id="live_dead" data-bv-notempty="true"'); ?>
                    </div>
                    
                    <div class="form-group">
                        <?= lang('mother_id', 'mother_id'); ?>
                        <?php echo form_input('mother_id', '', 'class="form-control" id="mother_id" data-bv-notempty="true"'); ?>
                    </div>
                    
                    <div class="form-group">
                        <?= lang('health_status', 'health_status'); ?>
                        <?php echo form_input('health_status', '', 'class="form-control" id="health_status" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('bcs', 'bcs'); ?>
                        <?php echo form_input('bcs', '', 'class="form-control" id="bcs" data-bv-notempty="true"'); ?>
                    </div>
                    
                    
                </div>
                <div class="col-md-4">
                    
                    <div class="form-group">
                        <?= lang('animal_id', 'animal_id'); ?>
                        <?php echo form_input('animal_id', '', 'class="form-control tip" id="animal_id" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('owner_name', 'owner_name'); ?>
                        <?php echo form_input('owner_name', '', 'class="form-control tip" id="owner_name" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('dob', 'dob'); ?>
                        <input name="dob" class="form-control datetime" required="required" id="dob"/>
                    </div>
                    <div class="form-group">
                        <?= lang('weaning_date', 'weaning_date'); ?>
                        <input name="weaning_date" class="form-control datetime" required="required" id="weaning_date"/>
                    </div>
                    <div class="form-group">
                        <?= lang('father_id', 'father_id'); ?>
                        <?php echo form_input('father_id', '', 'class="form-control" id="father_id" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('birth_status', 'birth_status'); ?>
                        <?php echo form_input('birth_status', '', 'class="form-control" id="birth_status" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('ben', 'ben'); ?>
                        <?php echo form_input('ben', '', 'class="form-control" id="ben" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('govt_animal_id', 'govt_animal_id'); ?>
                        <?php echo form_input('govt_animal_id', '', 'class="form-control tip" id="govt_animal_id" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('purchase_date', 'purchase_date'); ?>
                        <input name="purchase_date" class="form-control datetime" required="required" id="purchase_date"/>
                    </div>
                    <div class="form-group">
                        <?= lang('eew_ram', 'eew_ram'); ?>
                        <?php echo form_dropdown('eew_ram', array('eew' => lang('eew'), 'ram' => lang('ram')), '', 'class="form-control tip" id="eew_ram" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('subsidy', 'subsidy'); ?>
                        <?php echo form_input('subsidy', '', 'class="form-control tip" id="subsidy" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('remarks', 'remarks'); ?>
                        <?php echo form_input('remarks', '', 'class="form-control tip" id="remarks" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('milk_status', 'milk_status'); ?>
                        <?php echo form_input('milk_status', '', 'class="form-control" id="milk_status" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                
            </div>


        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_animal', lang('add_animal'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="<?= base_url() ?>assets/js/auto_search.js"></script>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
        auto_search('animal_tag', 'animals', 'animal_tag', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('mother_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('father_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('breed', 'breeds', 'breed', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('milk_status', 'animals', 'milk_status', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('health_status', 'animals', 'health_status', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('birth_status', 'animals', 'birth_status', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('ben', 'bens', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
        auto_search('owner_name', 'partners', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
    });
</script>
<style type="text/css">
ul.ui-autocomplete {
    z-index: 1100;
}
</style>
<?= $modal_js ?>
