<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Diseases_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addDiseases($data = [])
    {
        if ($this->db->insert_batch('diseases', $data)) {
            return true;
        }
        return false;
    }

    public function addDisease($data = [])
    {
        if ($this->db->insert('diseases', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteDisease($id)
    {
        if ($this->db->delete('diseases', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getDiseaseByEmail($email)
    {
        $q = $this->db->get_where('diseases', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getDiseaseByID($id)
    {
        $q = $this->db->get_where('diseases', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateDisease($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('diseases', $data)) {
            return true;
        }
        return false;
    }

}
