<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Breeds_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addBreeds($data = [])
    {
        if ($this->db->insert_batch('breeds', $data)) {
            return true;
        }
        return false;
    }

    public function addBreed($data = [])
    {
        if ($this->db->insert('breeds', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteBreed($id)
    {
        if ($this->db->delete('breeds', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getBreedByEmail($email)
    {
        $q = $this->db->get_where('breeds', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getBreedByID($id)
    {
        $q = $this->db->get_where('breeds', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateBreed($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('breeds', $data)) {
            return true;
        }
        return false;
    }

}
