<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Fodder_recs extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->load->library('upload');
        $this->lang->admin_load('fodder_recs', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('fodder_recs_model');
        $this->load->admin_model('products_model');
    }
    
    public function getProductByID_c() {
        $id = $this->input->get('id', 0);
        $row = $this->products_model->getProductByID($id);;
        $this->sma->send_json($row);
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);
        
        $item_obj = json_decode(stripslashes($this->input->post('item_name')), true);
        $item_name = '';
        
        foreach($item_obj as $p_id => $quantity) {
            $obj = $this->products_model->getProductByID($p_id);
            $item_name .= $obj->name . "(" . $quantity . ")" . ", ";
            
            //updating product quantity
            $new_quantity = (int)($obj->quantity) - (int)$quantity;
            $this->products_model->updateProductQuantity($p_id, $new_quantity);
            
            //updating purchase quantity_balance
            $obj1 = $this->products_model->getPurchaseByProductID($p_id);
            $new_quantity = (int)($obj1->quantity_balance) - (int)$quantity;
            $this->products_model->updatePurchaseQuantityBalance($p_id, $new_quantity);
        }
        
        if ($this->form_validation->run('fodder_recs/add') == true) {
            $data = [
                'slip_no' => $this->input->post('slip_no'),
                'item_name' => rtrim($item_name, ", "),
                'item_json' => stripslashes($this->input->post('item_name')),
                'slip_date' => $this->input->post('slip_date'),
                'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                // $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('fodder_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
        } elseif ($this->input->post('add_fodder_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('fodder_recs');
        }

        if ($this->form_validation->run() == true && $this->fodder_recs_model->addFodder_rec($data)) {
            $this->session->set_flashdata('message', $this->lang->line('fodder_rec_added'));
            admin_redirect('fodder_recs');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'fodder_recs/add', $this->data);
        }
    }

    public function fodder_rec_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->fodder_recs_model->deleteFodder_rec($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('fodder_recs_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('fodder_recs_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('fodder_recs'));
                        $this->excel->getActiveSheet()->SetCellValue('A1', lang('slip_no'));
                        $this->excel->getActiveSheet()->SetCellValue('B1', lang('item_name'));
                        $this->excel->getActiveSheet()->SetCellValue('C1', lang('item_json'));
                        $this->excel->getActiveSheet()->SetCellValue('D1', lang('slip_date'));
                        $this->excel->getActiveSheet()->SetCellValue('E1', lang('description'));
                    
                    

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $obj = $this->fodder_recs_model->getFodder_recByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $obj->slip_no);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $obj->item_name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $obj->item_json);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $obj->slip_date);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $obj->description);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'fodder_recs_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_fodder_rec_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->fodder_recs_model->deleteFodder_rec($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('fodder_rec_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('fodder_rec_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $fodder_rec_details = $this->fodder_recs_model->getFodder_recByID($id);

        $item_obj = json_decode(stripslashes($this->input->post('item_name')), true);
        $item_name = '';
        
        foreach($item_obj as $p_id => $quantity) {
            $obj = $this->products_model->getProductByID($p_id);
            $item_name .= $obj->name . "(" . $quantity . ")" . ", ";
            
            //updating product quantity
            $new_quantity = (int)($obj->quantity) - (int)$quantity;
            $this->products_model->updateProductQuantity($p_id, $new_quantity);
            
            //updating purchase quantity_balance
            $obj1 = $this->products_model->getPurchaseByProductID($p_id);
            $new_quantity = (int)($obj1->quantity_balance) - (int)$quantity;
            $this->products_model->updatePurchaseQuantityBalance($p_id, $new_quantity);
        }
        
        if ($this->form_validation->run('fodder_recs/add') == true) {
            $data = [
                'slip_no' => $this->input->post('slip_no'),
                'item_name' => rtrim($item_name, ", "),
                'item_json' => stripslashes($this->input->post('item_name')),
                'slip_date' => $this->input->post('slip_date'),
                'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                // $config['overwrite']     = true;
                // $config['file_name'] = $fodder_rec_details->image;
                
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('fodder_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
            
        } elseif ($this->input->post('edit_fodder_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('fodder_recs');
        }

        if ($this->form_validation->run() == true && $this->fodder_recs_model->updateFodder_rec($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('fodder_rec_updated'));
            admin_redirect('fodder_recs');
        } else {
            $this->data['fodder_rec']   = $fodder_rec_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'fodder_recs/edit', $this->data);
        }
    }

    public function getFodder_rec($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->fodder_recs_model->getFodder_recByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getFodder_recs()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, image, slip_no, item_name, slip_date')
            ->from('fodder_recs')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_fodder_rec') . "' href='" . admin_url('fodder_recs/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_fodder_rec') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('fodder_recs/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('fodder_recs')]];
        $meta                 = ['page_title' => lang('fodder_recs'), 'bc' => $bc];
        $this->page_construct('fodder_recs/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->fodder_recs_model->getFodder_recSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
    
    public function modal_view($id = null)
    {
        $this->sma->checkPermissions('index', true);

        $pr_details = $this->fodder_recs_model->getFodder_recByID($id);
        
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('fodder_rec_not_found'));
            $this->sma->md();
        }
        
        $this->data['fodder_rec']     = $pr_details;

        $this->load->view($this->theme . 'fodder_recs/modal_view', $this->data);
    }
    
    public function pdf($id = null, $view = null)
    {
        $this->sma->checkPermissions('index');

        $pr_details = $this->fodder_recs_model->getFodder_recByID($id);
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('prduct_not_found'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        
        $this->data['fodder_rec'] = $pr_details;

        $name = lang('fodder_rec') . '_' . $pr_details->id  . '.pdf';
        if ($view) {
            $this->load->view($this->theme . 'fodder_recs/pdf', $this->data);
        } else {
            $html = $this->load->view($this->theme . 'fodder_recs/pdf', $this->data, true);
            if (!$this->Settings->barcode_img) {
                $html = preg_replace("'\<\?xml(.*)\?\>'", '', $html);
            }
            $this->sma->generate_pdf($html, $name);
        }
    }

}
