<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Add_by_csvs extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->load->admin_model('add_by_csvs_model');
    }

    public function add($name)
    {
        $this->sma->checkPermissions(false, true);
            
            if ($_FILES['csv_file']['size'] > 0) {
                
                // $this->sma->print_arrays([$_FILES['csv_file']['size']]);
                // return;
                
                $this->load->library('upload');
                $config['upload_path']   = 'assets/uploads/csv';
                $config['allowed_types'] = 'csv';
                $config['max_size']      = $this->allowed_file_size;
                $config['overwrite']     = false;
                $config['encrypt_name']  = true;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('csv_file')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER['HTTP_REFERER']);
                }
            
                $csv = $this->upload->file_name;
                $data['attachment'] = $csv;
            
                $arrResult = [];
                $handle = fopen('assets/uploads/csv/' . $csv, 'r');
                $titles = [];
                if ($handle) {
                    while (($row = fgetcsv($handle, 5000, ',')) !== false) {
                        if (!$titles) {
                             $titles = $row;
                        } else {
                            $arrResult[] = array_combine($titles, $row);
                        }
                        
                    }
                    fclose($handle);
                }

                // $this->sma->print_arrays($arrResult);
                
                if ($this->add_by_csvs_model->addCsvs($arrResult, $name)) {
                    $this->session->set_flashdata('message', lang($name) . " " . lang('added_successfully'));
                    $this->data['db_name'] = $name;
                    $meta = ['page_title' => lang('add_data_by_csv')];
                    $this->page_construct('add_by_csv', $meta, $this->data);
                } else {
                    $this->data['error']    = ($this->session->flashdata('error'));
                    $this->data['db_name'] = $name;
                    $meta = ['page_title' => lang('add_data_by_csv')];
                    $this->page_construct('add_by_csv', $meta, $this->data);
                }
                
                } else {
                    $this->data['db_name'] = $name;
                    $meta = ['page_title' => lang('add_data_by_csv')];
                    $this->page_construct('add_by_csv', $meta, $this->data);
                }
            
    }
    
}